import 'package:dio/dio.dart';

import '../../core/config/api_endpoints.dart';
import '../../core/state/rider_service_state.dart';
import '../../domain/interfaces/ride_service_interface.dart';
import 'api/dio_client.dart';

class RideServicesService implements IRideServicesService {
  final DioClient dioClient;

  RideServicesService({required this.dioClient});
  @override
  Future<Response> getRideServices(
      {required RiderServiceState riderServiceState}) async => dioClient.dio.get(ApiEndpoints.rideServices,
        queryParameters: riderServiceState.toMap());

  @override
  Future<Response> getServicesHome() => dioClient.dio.get(ApiEndpoints.servicesHome,);

  @override
  Future<Response> applyCoupon({String? coupon}) async => await dioClient.dio.get(ApiEndpoints.applyCoupon, queryParameters: {'coupon_code': coupon ?? ''});
}
